/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: EcatFoE_Public.h $

    $GlobalRev: 63951 $
    $Version: V2.5.42.0 $
    $Packaged: 2016-09-12 15:21 $

   Targets:
    rcX          : yes

   Description:

    EtherCAT FoE part
    packet definitions

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
      2      14.01.2008     sb
        added error codes from specification

      1      01.06.2006     sb
        Created

**************************************************************************************/

#ifndef __ECATFOE_PUBLIC_H
#define __ECATFOE_PUBLIC_H


/* EtherCAT FoE commands */
#define ECAT_FOE_REGISTERCB_REQ                       0x000019B0
#define ECAT_FOE_REGISTERCB_CNF                       0x000019B1

/* Timeout configuration commands */
#define ECAT_FOE_SET_TIMEOUTS_REQ                     0x00001B5A
#define ECAT_FOE_SET_TIMEOUTS_CNF                     0x00001B5B
#define ECAT_FOE_GET_TIMEOUTS_REQ                     0x00001B5C
#define ECAT_FOE_GET_TIMEOUTS_CNF                     0x00001B5D

/***************************************************************************************/
/* Ecat FoE public, types */


typedef TLR_UINT32 ECAT_FOE_ERROR_CODE;
#define ECAT_FOE_SUCCESS                                ((ECAT_FOE_ERROR_CODE)0)
#define ECAT_FOE_UNDEFINED_ERROR                        ((ECAT_FOE_ERROR_CODE)0x00008000)
#define ECAT_FOE_NOT_FOUND                              ((ECAT_FOE_ERROR_CODE)0x00008001)
#define ECAT_FOE_ACCESS_DENIED                          ((ECAT_FOE_ERROR_CODE)0x00008002)
#define ECAT_FOE_DISK_FULL                              ((ECAT_FOE_ERROR_CODE)0x00008003)
#define ECAT_FOE_ILLEGAL                                ((ECAT_FOE_ERROR_CODE)0x00008004)
#define ECAT_FOE_PACKET_NUMBER_WRONG                    ((ECAT_FOE_ERROR_CODE)0x00008005)
#define ECAT_FOE_ALREADY_EXISTS                         ((ECAT_FOE_ERROR_CODE)0x00008006)
#define ECAT_FOE_NO_USER                                ((ECAT_FOE_ERROR_CODE)0x00008007)
#define ECAT_FOE_BOOTSTRAP_ONLY                         ((ECAT_FOE_ERROR_CODE)0x00008008)
#define ECAT_FOE_NOT_BOOTSTRAP                          ((ECAT_FOE_ERROR_CODE)0x00008009)
#define ECAT_FOE_NO_RIGHTS                              ((ECAT_FOE_ERROR_CODE)0x0000800A)
#define ECAT_FOE_PROGRAM_ERROR                          ((ECAT_FOE_ERROR_CODE)0x0000800B)

/* special error for diagnosis */
#define ECAT_FOE_FIXME_ERROR          ((ECAT_FOE_ERROR_CODE)0xFFFFFFFF)


typedef TLR_UINT ECAT_FOE_MODE;
#define ECAT_FOE_MODE_OPENREAD  ((ECAT_FOE_MODE)0)
#define ECAT_FOE_MODE_OPENWRITE ((ECAT_FOE_MODE)1)
#define ECAT_FOE_MODE_READ      ((ECAT_FOE_MODE)2)
#define ECAT_FOE_MODE_WRITE     ((ECAT_FOE_MODE)3)
#define ECAT_FOE_MODE_CLOSE     ((ECAT_FOE_MODE)4)
#define ECAT_FOE_MODE_FAILCLOSE ((ECAT_FOE_MODE)5) /* file close on remote read or write failure */
#define ECAT_FOE_MODE_SEEK      ((ECAT_FOE_MODE)6)

/* these functions have to change the supplied string when returning FALSE */
typedef ECAT_FOE_ERROR_CODE (* ECAT_FOE_CALLBACK_T)(
  TLR_HANDLE * phFile,
  TLR_STR * pszName,
  TLR_UINT32 uPassword,
  ECAT_FOE_MODE uMode,
  void* pvData,
  TLR_UINT* puDataSize,
  void* pvUserData
);

/*
 * modes of ECAT_FOE_CALLBACK_T:   phFile     pszName     uPassword    pvData       puDataSize
 *
 * OPENREAD                        req. out   req. in     req. in      NULL         NULL
 * OPENWRITE                       req. out   req. in     req. in      NULL         req. out expected file size or 0
 * READ                            req. in    NULL        0            req. inout   req. inout
 * WRITE                           req. in    NULL        0            req. in      req. out
 * CLOSE                           req. in    NULL        0            NULL         NULL
 * FAILCLOSE                       req. in    NULL        0            NULL         NULL
 * SEEK                            req. in    NULL        0            NULL         ptr to req. file offset
 */

/***************************************************************************************/
/* Ecat FoE public, packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(ECAT_FOE_PUBLIC)
#endif


/* packet data */

struct ECAT_FOE_TIMEOUTS_DATA_Ttag
{
  /* Timer granularity */
  TLR_UINT32                  ulTimerGran;
  /* protocol timeout */
  TLR_UINT32                  ulProtocolTimeout;
};

typedef struct ECAT_FOE_TIMEOUTS_DATA_Ttag ECAT_FOE_SET_TIMEOUTS_DATA_T;
typedef struct ECAT_FOE_TIMEOUTS_DATA_Ttag ECAT_FOE_GET_TIMEOUTS_DATA_T;


/* request packets */

typedef struct ECAT_FOE_REGISTERCB_REQ_DATA_Ttag
{
  ECAT_FOE_CALLBACK_T fnCb;
  void* pvUserData;
} ECAT_FOE_REGISTERCB_REQ_DATA_T;

struct ECAT_FOE_REGISTERCB_REQ_Ttag
{
  TLR_PACKET_HEADER_T            tHead;
  ECAT_FOE_REGISTERCB_REQ_DATA_T tData;
};

typedef struct ECAT_FOE_REGISTERCB_REQ_Ttag ECAT_FOE_REGISTERCB_REQ_T;
#define ECAT_FOE_REGISTERCB_DATA_REQ_SIZE (sizeof(ECAT_FOE_REGISTERCB_REQ_T)-sizeof(TLR_PACKET_HEADER_T))

struct ECAT_FOE_SET_TIMEOUTS_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  ECAT_FOE_SET_TIMEOUTS_DATA_T  tData;
};

typedef struct ECAT_FOE_SET_TIMEOUTS_REQ_Ttag ECAT_FOE_SET_TIMEOUTS_REQ_T;
typedef TLR_EMPTY_PACKET_T ECAT_FOE_GET_TIMEOUTS_REQ_T;

/* confirmation packets */


typedef TLR_EMPTY_PACKET_T ECAT_FOE_REGISTERCB_CNF_T;
typedef TLR_EMPTY_PACKET_T ECAT_FOE_SET_TIMEOUTS_CNF_T;

struct ECAT_FOE_GET_TIMEOUTS_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  ECAT_FOE_GET_TIMEOUTS_DATA_T  tData;
};

typedef struct ECAT_FOE_GET_TIMEOUTS_CNF_Ttag ECAT_FOE_GET_TIMEOUTS_CNF_T;


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(ECAT_FOE_PUBLIC)
#endif


#endif
